#ifndef W32_OPTION_H
#define W32_OPTION_H

#define  STRICT
#include <windows.h>

#include "playlist.h"

extern OPENFILENAME ofnOutput;
extern char OutputFilter[];
extern char OutputFilename[MAX_PATH]; // Name of PCM wave output file

// Sets up the OPENFILENAME structures
void setup_option_ofn(LPSTR title);

// Property sheet creator, and handlers for each sheet
void CreatePropertySheet();

BOOL WINAPI    Gen_Options(HWND hDlg, UINT message,
				  	            WPARAM wParam, LPARAM lParam);
BOOL WINAPI   MPEG_Options(HWND hDlg, UINT message, WPARAM wParam,
				   				LPARAM lParam);
BOOL WINAPI Output_Options(HWND hDlg, UINT message, WPARAM wParam,
								   LPARAM lParam);
BOOL WINAPI     PL_Options(HWND hDlg, UINT message, WPARAM wParam,
				               LPARAM lParam);
BOOL WINAPI  Lyric_Options(HWND hDlg, UINT message, WPARAM wParam,
				               LPARAM lParam);
BOOL WINAPI  Image_Options(HWND hDlg, UINT message, WPARAM wParam,
				               LPARAM lParam);

// Reads and writes settings in the registry
void settings(BOOL write_mode);

#endif // W32_OPTION_H