#define  STRICT
#include <windows.h>
#include <string.h>

#include "w32_util.h"

void report_mci_error(HWND hWnd0, DWORD error, LPSTR heading)
{
   char scr[1024];
   mciGetErrorString(error, scr, 1024);
   MessageBox(hWnd0, scr, heading, MB_OK | MB_ICONEXCLAMATION);
}

int get_dropped_files(LPSTR ret_str, int max_file_len,
                      HDROP hDrop)
{
   int i;
   int num_files = DragQueryFile((HDROP) hDrop, 0xFFFFFFFF,
                                 ret_str, max_file_len);
   int length;
   LPSTR str_ptr = ret_str;

   for (i=0; i<num_files; i++) {
       DragQueryFile(hDrop, i, str_ptr, max_file_len);
       length = lstrlen(str_ptr);
       str_ptr += (length + 1);
   }

   *str_ptr = '\0';
   DragFinish(hDrop);

   return num_files;
}

BOOL launch_file(LPSTR filename, HWND hSender,
			        LPSTR cmdline, LPSTR cust_exe_name)
{
   if ((cust_exe_name == NULL) ||
       (lstrcmp(cust_exe_name, "") == 0)) {

		SHELLEXECUTEINFO sei;

   	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	   sei.fMask  = SEE_MASK_DOENVSUBST | SEE_MASK_NOCLOSEPROCESS |
	                SEE_MASK_FLAG_NO_UI;
	   sei.hwnd   = hSender;
	   sei.lpVerb = "Open";
	   sei.lpFile = filename;
	   sei.lpParameters = cmdline;
	   sei.lpDirectory = NULL;
	   sei.nShow = SW_SHOWNORMAL;

   	return ShellExecuteEx(&sei);

   } else {
      STARTUPINFO sui;
      PROCESS_INFORMATION proc_info;
      char full_cmdline[MAX_PATH * 2];

      lstrcpy(full_cmdline, cmdline);
      lstrcat(full_cmdline, " \"");
      lstrcat(full_cmdline, filename);
      lstrcat(full_cmdline, "\"");

      sui.cb = sizeof(STARTUPINFO);
      sui.lpReserved = NULL;
      sui.lpTitle = NULL;
      sui.dwFlags = 0;
      sui.cbReserved2 = 0;
      sui.lpReserved2 = NULL;

      return CreateProcess(cust_exe_name, full_cmdline, NULL,
                           NULL, FALSE,
                           CREATE_DEFAULT_ERROR_MODE | CREATE_NEW_PROCESS_GROUP,
                           NULL, NULL, &sui, &proc_info);
   }
}

