/* indigo_obuffer.h

	Obuffer for Silicon Graphics Indigo written by
   Tobias Bading (bading@cs.tu-berlin.de)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef INDIGO_OBUFFER_H
#define INDIGO_OBUFFER_H

#ifdef IRIX

#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/time.h>

extern "C" {
#include <audio.h>
}

#include "args.h"
#include "obuffer.h"

// a class for direct sound output on SGI machines:
class IndigoObuffer : public Obuffer
{
private:
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  ALport port;

public:
	IndigoObuffer (uint32 number_of_channels, MPEG_Args *maplay_args);
       ~IndigoObuffer (void);
  void	append (uint32 channel, int16 value);
  void	write_buffer (int dummy);

#ifdef SEEK_STOP
  void clear_buffer(void);
  void set_stop_flag(void);
#endif // SEEK_STOP

};
#endif	// IRIX

#endif // INDIGO_OBUFFER_H

