/* sparc_obuffer.h

   Output buffer for Sun SPARC systems written by
   Tobias Bading (bading@cs.tu-berlin.de)

   Idea and first implementation for u-law output with fast downsampling by
   Jim Boucher (jboucher@flash.bu.edu)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef SPARC_OBUFFER_H
#define SPARC_OBUFFER_H

#ifdef SPARC

#include "all.h"
#include "args.h"
#include "obuffer.h"

// a class for direct sound output on SPARC 10 machines (dbri device)
// or if ULAW is defined:
// a class for direct sound output on SPARCs using a 8 kHz
// 8-bit u-law audio device: (audioamd)
class SparcObuffer : public Obuffer
{
private:
#ifdef ULAW
  ulawsample buffer[OBUFFERSIZE >> 1];		// mono only
  ulawsample *bufferp;
#else
  int16 buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
#endif
  static int audio_fd;

  static int open_audio_device (void);
#ifdef Solaris
  static void get_device_type (int fd, audio_device *);
#else
  static int get_device_type (int fd);
#endif

public:
#ifdef ULAW
	SparcObuffer (MPEG_Args *maplay_args);
#else
	SparcObuffer (uint32 number_of_channels, MPEG_ARGS *maplay_args);
#endif
       ~SparcObuffer (void);
  void	append (uint32 channel, int16 value);
  void	write_buffer (int dummy);

#ifdef SEEK_STOP
  void clear_buffer(void);
  void set_stop_flag(void);
#endif // SEEK_STOP

#ifdef ULAW
  static BOOL class_suitable (uint32 number_of_channels, BOOL force_amd);
	// returnvalue == False: no u-law output possible (class unsuitable)
#else
  static BOOL class_suitable (void);
	// returnvalue == False: no 16-bit output possible (class unsuitable)
#endif
};
#endif // SPARC

#endif // SPARC_OBUFFER_H
