/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS 
and edited by
Yoshiaki Oikawa (Sony Corporation),
Mitsuyuki Hatanaka (Sony Corporation)
in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

#include "all.h"
#ifdef	DOLBY_MDCT
#include "dolby_def.h"
#endif
#if (CChans > 0)

static	Float	    cc_gain_scale[4];
static	int	    *cc_lpflag[CChans];
static	int	    *cc_prstflag[CChans];
static	PRED_STATUS *cc_sp_status[CChans];
#ifdef MPEG4V1
static	NOK_LT_PRED_STATUS *nok_cc_ltp_status[CChans];
#endif
static	Float	    *cc_prev_quant[CChans];
static	byte	    *cc_group[CChans];

void
init_cc(void)
{
    int i, ch;
    cc_gain_scale[3] = 2.0;

    /* initialize gain scale */
    for (i=2; i>=0; i--)
	cc_gain_scale[i] = sqrt(cc_gain_scale[i+1]);

    /* coupling channel predictors */
    for (ch = 0; ch < CChans; ch++) {
	cc_lpflag[ch] = (int*)mal1(MAXBANDS*sizeof(*cc_lpflag[0]));
	cc_prstflag[ch] = (int*)mal1((LEN_PRED_RSTGRP+1)*sizeof(*cc_prstflag[0]));
	cc_sp_status[ch] = (PRED_STATUS*)mal1(LN*sizeof(*cc_sp_status[0]));
	cc_prev_quant[ch] = (Float*)mal1(LN2*sizeof(*cc_prev_quant[0]));
	cc_group[ch] = (byte*)mal1(MAXBANDS*sizeof(*cc_group[0]));
	for (i = 0; i < LN2; i++) {
	    init_pred_stat(&cc_sp_status[ch][i],
	        PRED_ORDER,PRED_ALPHA,PRED_A,PRED_B);
	    cc_prev_quant[ch][i] = 0.;
	}
#ifdef MPEG4V1
    /* coupling channel long term prediction.  */
	nok_cc_ltp_status[ch]  = (NOK_LT_PRED_STATUS *)mal1(sizeof(*nok_cc_ltp_status[0]));
	nok_init_lt_pred (nok_cc_ltp_status[ch]);
#endif
    }
}

/*
 * get scale factors from simpler cb_map information
 */
int
cc_hufffac(Info *info, byte *group, byte *cb_map, short global_gain, 
    short *factors)
{
    Hcb *hcb;
    Huffman *hcw;
    int i, b, bb, t, n, fac, is_pos;
#ifdef MPEG4V1
    int noise_pcm_flag = 1;
    int noise_nrg;
#endif

    /* clear array for the case of max_sfb == 0 */
    shortclr(factors, MAXBANDS);

    /* scale factors are dpcm relative to global gain
     * intensity positions are dpcm relative to zero
     */
    fac = global_gain;
    is_pos = 0;
#ifdef MPEG4V1
    noise_nrg = global_gain - NOISE_OFFSET;
#endif

    /* get scale factors */
    hcb = &book[BOOKSCL];
    hcw = hcb->hcw;
    bb = 0;
    if (debug['f'])
	PRINT(SE,"scale factors\n");
    for(b = 0; b < info->nsbk; ){
	n = info->sfb_per_sbk[b];
	b = *group++;
	for(i = 0; i < n; i++){
	    switch (cb_map[i]) {
	    case ZERO_HCB:	    /* zero book */
		break;
	    default:		    /* spectral books */
		/* decode scale factor */
		t = decode_huff_cw(hcw);
		fac += t - MIDFAC;    /* 1.5 dB */
		if(fac >= 2*maxfac || fac < 0)
		    return 0;
		factors[i] = fac;
		break;
	    case BOOKSCL:	    /* invalid books */
#ifndef MPEG4V1
	    case RESERVED_HCB:
#endif
		return 0;
	    case INTENSITY_HCB:	    /* intensity books */
	    case INTENSITY_HCB2:
		/* decode intensity position */
		t = decode_huff_cw(hcw);
		is_pos += t - MIDFAC;
		factors[i] = is_pos;
		break;
#ifdef MPEG4V1
	    case NOISE_HCB:	    /* noise books */
                /* decode noise energy */
                if (noise_pcm_flag) {
                  noise_pcm_flag = 0;
                  t = getbits( NOISE_PCM_BITS ) - NOISE_PCM_OFFSET;
                }
                else
                  t = decode_huff_cw(hcw) - MIDFAC;
                noise_nrg += t;
                if (debug['f'])
                  PRINT(SE,"\n%3d %3d (noise, code %d)", i, noise_nrg, t);
                factors[i] = noise_nrg;
                break;
#endif


    	    }
	    if (debug['f'])
	       PRINT(SE,"%3d: %3d %3d\n", i, cb_map[i], factors[i]);
	}
	if (debug['f'])
	   PRINT(SE,"\n");

	/* expand short block grouping */
	if (!(info->islong)) {
	    for(bb++; bb < b; bb++) {
		for (i=0; i<n; i++) {
		    factors[i+n] = factors[i];
		}
		factors += n;
	    }
	}
	cb_map += n;
	factors += n;
    }
    return 1;
}

int
getcc(MC_Info *mip, byte *cc_wnd, Wnd_Shape *cc_wnd_shape, Float **cc_coef,
Float *cc_gain[CChans][Chans])
{
    int i, j, k, m, n, cpe, tag, cidx, ch, nele, nch;
    int target[Chans], shared[Chans];
    int cc_l, cc_r, cc_dom, cc_gain_ele_sign, ind_sw_cc, cgep, scl_idx,
    sign, fac;
    byte cb_map[MAXBANDS], cc_max_sfb[CChans];
    short global_gain, factors[MAXBANDS];
    Float scale;
    Info *info;
    TNS_frame_info tns;

#ifdef  SSR
    int dummy = 0;
#endif

    tag = getbits(LEN_TAG);

    if (default_config) {
	cidx = mip->ncch;
    }
    else {
	cidx = XCChans;	    /* default is scratch index */
	for (i=0; i<mip->ncch; i++) {
	    if (mip->cch_tag[i] == tag)
		cidx = i;
	}
    }
    
    if (cidx >= CChans) {
	PRINT(SE, "Unanticipated coupling channel\n");
	myexit("coupling");
    }

    /*  get ind_sw_cce flag */
    ind_sw_cc = getbits(LEN_IND_SW_CCE);
    
    /* coupled (target) elements */
    nele = getbits(LEN_NCC);
    nch = 0;
    for (i=0; i<nele; i++) {
	cpe = getbits(LEN_IS_CPE);
	tag = getbits(LEN_TAG);
	ch = ch_index(mip, cpe, tag);
	
	if (!cpe) {
	    target[nch] = ch;
	    shared[nch++] = 0;
	}
	else {
	    cc_l = getbits(LEN_CC_LR);
	    cc_r = getbits(LEN_CC_LR);
	    j = (cc_l<<1) | cc_r;
	    switch(j) {
	    case 0:	    /* shared gain list */
		target[nch] = ch;
		target[nch+1] = mip->ch_info[ch].paired_ch;
		shared[nch] = 1;
		shared[nch+1] = 1;
		nch += 2;
		break;
	    case 1:	    /* left channel gain list */
		target[nch] = ch;
		shared[nch] = 0;
		nch += 1;
		break;
	    case 2:	    /* right channel gain list */
		target[nch+1] = mip->ch_info[ch].paired_ch;
		shared[nch] = 0;
		nch += 1;
		break;
	    case 3:	    /* two gain lists */
		target[nch] = ch;
		target[nch+1] = mip->ch_info[ch].paired_ch;
		shared[nch] = 0;
		shared[nch+1] = 0;
		nch += 2;
		break;
	    }
	}
    }
    
    cc_dom = getbits(LEN_CC_DOM);
    cc_gain_ele_sign = getbits(LEN_CC_SGN);
    scl_idx = getbits(LEN_CCH_GES);

    /*
     * coupling channel bitstream
     * (equivalent to SCE)
     */
    fltclr(cc_coef[cidx], LN2);
    memcpy(&info, winmap[cc_wnd[cidx]], sizeof(Info));
    if (!getics(info, 0, &cc_wnd[cidx], &cc_wnd_shape[cidx].this_bk,
        cc_group[cidx], &cc_max_sfb[cidx], cc_lpflag[cidx], cc_prstflag[cidx],
        cb_map, cc_coef[cidx], &global_gain, factors
#ifdef MPEG4V1
        , nok_cc_ltp_status[cidx]
#endif
        , &tns
#ifdef  SSR
    , dummy
#endif
		))
	return -1;

    /* coupling for first target channel(s) is already at
     * correct scale
     */
    ch = shared[0] ? 2 : 1;
    for (j=0; j<ch; j++)
	for (i=0; i<MAXBANDS; i++)
	    cc_gain[cidx][target[j]][i] = 1.0;

    /*
     * bitstreams for target channel scale factors
     */
    for (; ch<nch; ) {
	/* if needed, get common gain elment present */
	cgep = ind_sw_cc ? 1 : getbits(LEN_CCH_CGP);
	if (cgep) {
	    /* common gain */
	    int t;
	    Hcb *hcb;
	    Huffman *hcw;

	    /*  get ind_sw_cce flag */
	    ind_sw_cc = getbits(LEN_IND_SW_CCE);

	    /*  get just one scale factor */
	    hcb = &book[BOOKSCL];
	    hcw = hcb->hcw;
	    fac = 0;    /* dpcm relative to 0 */
	    t = decode_huff_cw(hcw);
	    fac += t - MIDFAC;    /* 1.5 dB */

	    /* recover stepsize */
	    scale = cc_gain_scale[scl_idx];
	    scale = pow(scale, fac);

	    /* copy to gain array */
	    n = shared[ch] ? 2 : 1;
	    for (m=0; m<n; m++) {
		k=0;
		for (i=0; i<info->nsbk; i++)
		    for (j=0; j<info->sfb_per_sbk[i]; j++)
			cc_gain[cidx][target[ch]][k++] = scale;
		ch++;
	    }
	}
	else {
	    /* must be dependently switched cce */
	    ind_sw_cc = 0;
	    
	    /* get scale factors
	     * use sectioning of coupling channel
	     */
	    cc_hufffac(info, cc_group[cidx], cb_map, global_gain, factors);

	    /* recover sign and stepsize */
	    scale = cc_gain_scale[scl_idx];
	    k=0;
	    for (i=0; i<info->nsbk; i++) {
		for (j=0; j<info->sfb_per_sbk[i]; j++) {
		    fac = factors[k];
		    if (cc_gain_ele_sign) {
			sign = fac & 1;
			fac >>= 1;
		    }
		    else {
			sign = 1;
		    }
		    scale = pow(scale, fac);
		    scale *= (sign==0) ? 1 : -1;
		    cc_gain[cidx][target[ch]][k++] = scale;
		}
	    }
	    /* shared gain lists */
	    if ( shared[ch] ) {
		for (i=0; i<MAXBANDS; i++)
		    cc_gain[cidx][target[ch+1]][k] = 
		        cc_gain[cidx][target[ch]][k];
		ch++;
	    }
	}
    }

    /* process coupling channel the same as other channels, 
     * except that it can only be a SCE
     */
#ifndef MPEG4V1
    predict(info, mip->profile,
	cc_lpflag[cidx], cc_sp_status[cidx], cc_coef[cidx]);
    predict_reset(info, cc_prstflag[cidx], cc_sp_status, cidx, cidx);
#else
    /* Long term prediction.  */
    nok_lt_predict (mip->profile, info, cc_wnd[cidx],
		    &cc_wnd_shape[cidx],
		    nok_cc_ltp_status[cidx]->sbk_prediction_used,
		    nok_cc_ltp_status[cidx]->sfb_prediction_used,
		    nok_cc_ltp_status[cidx], nok_cc_ltp_status[cidx]->weight,
		    nok_cc_ltp_status[cidx]->delay, cc_coef[cidx],
		    BLOCK_LEN_LONG, 0, BLOCK_LEN_SHORT);
#endif

    for (i=j=0; i<tns.n_subblocks; i++) {
	tns_decode_subblock(&cc_coef[cidx][j],
	    cc_max_sfb[cidx], 
	    info->sbk_sfb_top[i],
	    info->islong,
	    &(tns.info[i]) );
	j += info->bins_per_sbk[i];
    }

    /* invert the cch to ch mapping */
    for (i=0; i<nch; i++) {
	mip->ch_info[target[i]].ncch = cidx+1;
	mip->ch_info[target[i]].cch[cidx] = cidx;
	mip->ch_info[target[i]].cc_dom[cidx] = cc_dom;
	mip->ch_info[target[i]].cc_ind[cidx] = ind_sw_cc;
    }

    if (default_config)
	mip->ncch++;
	
    return 1;
}

#if (ICChans > 0)
/* transform independently switched coupling channels into
 * time domain
 */
void
ind_coupling(MC_Info *mip, byte *wnd, Wnd_Shape *wnd_shape,
    byte *cc_wnd, Wnd_Shape *cc_wnd_shape, Float *cc_coef[CChans],
    Float *cc_state[CChans])
{
    int ch, cidx;
    Ch_Info *cip;

    for (ch=0; ch<Chans; ch++) {
	cip = &mip->ch_info[ch];
	for (cidx=0; cidx<mip->ncch; cidx++) {
	    if (cip->cc_ind[cidx]) {
		Float data[LN2];
		freq2time_adapt(cc_wnd[cidx], &cc_wnd_shape[cidx],
		    cc_coef[cidx], cc_state[cidx], data);
		fltcpy(cc_coef[cidx], data, LN2);
	    }
	}
    }
}
#endif
	

static void
mix_cc(Info *info, Float *coef, Float *cc_coef, Float *cc_gain, int ind)
{
    int nsbk, sbk, sfb, nsfb, k, top;
    Float scale;

    if (!ind) {    
	/* frequency-domain coupling */
	k = 0;
	nsbk = info->nsbk;
	for (sbk=0; sbk<nsbk; sbk++) {
	    nsfb = info->sfb_per_sbk[sbk];
	    for (sfb=0; sfb<nsfb; sfb++) {
		top = info->sbk_sfb_top[sbk][sfb];
		scale = *cc_gain++;
		if (scale == 0) {
		    /* no coupling */
		    k = top;
		}
		else {
		    /* mix in coupling channel */
		    while (k<top) {
			coef[k] += cc_coef[k] * scale;
			k++;
		    }
		}
	    }
	}
    }
    else {
	/* time-domain coupling (coef[] is actually data[]!) */
	scale = *cc_gain;
	for (k=0; k<LN2; k++) 
	    coef[k] += cc_coef[k] * scale;
    }	
}
   
void
coupling(Info *info, MC_Info *mip, Float **coef, Float **cc_coef,
    Float *cc_gain[CChans][Chans], int ch, int cc_dom, int cc_ind)
{
    int i, j, wn, cch, ind;    
    Ch_Info *cip = &mip->ch_info[ch];
       
    j=cip->ncch;
    for (i=0; i<j; i++) {
	if (!cc_ind && (cc_dom != cip->cc_dom[i]) )
	    continue;
	wn = cip->widx;
	cch = cip->cch[i];
	ind = cip->cc_ind[i];
	if (debug['c'])
	    PRINT(SE, "mixing cch %d onto ch %d, mode %d %d\n",
		cch, ch, cc_dom, cc_ind);
	mix_cc(info, coef[ch], cc_coef[cch], cc_gain[cch][ch], ind);
    }
}

#endif	/* (CChan > 0) */
