/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS 
and edited by
Yoshiaki Oikawa (Sony Corporation),
Mitsuyuki Hatanaka (Sony Corporation)
in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

#include "all.h"
#ifdef	DOLBY_MDCT
#include "block.h"
#include "dolby_def.h"
#endif
#ifdef MPEG4V1
#include "nok_lt_prediction.h"
#endif

#ifdef  SSR
void gain_control(float  *freqSigCh,
				  Wnd_Shape	*wnd_shape,
				  int window_sequenceCh,
				  int ch,
				  float   *timeSigCh
				  );
#endif

/* prediction */
static	PRED_STATUS	*sp_status[Chans];
#ifdef MPEG4V1
/* long term prediction */
static  NOK_LT_PRED_STATUS *nok_lt_status[Chans];
#endif

void
init(void)
{
#ifndef	DOLBY_MDCT
    imdctinit();
#endif
#if (CChans > 0)
    init_cc();
#endif
    huffbookinit();
    predinit();
    

    winmap[0] = win_seq_info[ONLY_LONG_WINDOW];
    winmap[1] = win_seq_info[ONLY_LONG_WINDOW];
    winmap[2] = win_seq_info[EIGHT_SHORT_WINDOW];
    winmap[3] = win_seq_info[ONLY_LONG_WINDOW];      
}

void
predinit(void)
{
    int i, ch;
    for (ch = 0; ch < Chans; ch++) {
	for (i = 0; i < LN2; i++) {
	    init_pred_stat(&sp_status[ch][i],
	        PRED_ORDER,PRED_ALPHA,PRED_A,PRED_B);
	}
    }
#ifdef MPEG4V1
    for (ch = 0; ch < Chans; ch++) {
      nok_init_lt_pred(nok_lt_status[ch]);
    }
#endif
}

int
getdata(int *tag, int *dt_cnt, byte *data_bytes)
{
    int i, align_flag, cnt;

    *tag = getbits(LEN_TAG);
    align_flag = getbits(LEN_D_ALIGN);
    if ((cnt = getbits(LEN_D_CNT)) == (1<<LEN_D_CNT)-1)
	cnt +=  getbits(LEN_D_ESC);
    *dt_cnt = cnt;
    if (debug['x'])
	PRINT(SE, "data element %d has %d bytes\n", *tag, cnt);
    if (align_flag)
	byte_align();

    for (i=0; i<cnt; i++) {
	data_bytes[i] = getbits(LEN_BYTE);
	if (debug['X'])
	    PRINT(SE, "%6d %2x\n", i, data_bytes[i]);
    }
    
    return 0;
}

void
getfill(void)
{
    int i, cnt;

    if ((cnt = getbits(LEN_F_CNT)) == (1<<LEN_F_CNT)-1)
	cnt +=  getbits(LEN_F_ESC) - 1;
    if (debug['x'])
	PRINT(SE, "fill element has %d bytes\n", cnt);
    for (i=0; i<cnt; i++)
	getbits(LEN_BYTE);
}

void
main(int argc, char *argv[])
{
    Float *coef[Chans], *data[Chans], *state[Chans];
    byte hasmask[Winds], *mask[Winds], *group[Chans],
        wnd[Chans], max_sfb[Chans],
	*cb_map[Chans], d_bytes[Avjframe];
    Wnd_Shape wnd_shape[Chans];
    short *factors[Chans];
    int *lpflag[Chans], *prstflag[Chans];
    TNS_frame_info *tns[Chans];
#if (CChans > 0)
    Float *cc_coef[CChans], *cc_gain[CChans][Chans];
    byte cc_wnd[CChans];
    Wnd_Shape cc_wnd_shape[CChans];
#if (ICChans > 0)
    Float *cc_state[ICChans];
#endif
#endif

    int i, j,  ch, wn, ele_id, d_tag, d_cnt;
    int left, right;
    Info *info;
    MC_Info *mip = &mc_info;
    Ch_Info *cip;

#ifdef  SSR
    Wnd_Shape	wnd_shape_SSR[Chans];
#endif

    for(i=0; i<Chans; i++){
	coef[i] = (Float *)mal1(LN2*sizeof(*coef[0]));
	data[i] = (Float *)mal1(LN2*sizeof(*data[0]));
	state[i] = (Float *)mal1(LN*sizeof(*state[0]));	/* changed LN4 to LN 1/97 mfd */
	fltclr(state[i], LN);
	factors[i] = (short *)mal1(MAXBANDS*sizeof(*factors[0]));
	cb_map[i] = (byte *)mal1(MAXBANDS*sizeof(*cb_map[0]));
	group[i] = (byte *)mal1(NSHORT*sizeof(group[0]));
	lpflag[i] = (int *)mal1(MAXBANDS*sizeof(*lpflag[0]));
	prstflag[i] = (int *)mal1((LEN_PRED_RSTGRP+1)*sizeof(*prstflag[0]));
	tns[i] = (TNS_frame_info *)mal1(sizeof(*tns[0]));
	sp_status[i]  = (PRED_STATUS *)mal1(LN*sizeof(*sp_status[0]));
	wnd_shape[i].prev_bk = 0;
#ifdef MPEG4V1
	nok_lt_status[i]  = (NOK_LT_PRED_STATUS *)mal1(sizeof(*nok_lt_status[0]));
	nok_lt_status[i]->delay =  (int*)mal1(MAX_SHORT_WINDOWS*sizeof(int));
#endif
    }
    for(i=0; i<Winds; i++) {
	mask[i] = (byte *)mal1(MAXBANDS*sizeof(mask[0]));
    }
#if (CChans > 0)
    for(i=0; i<CChans; i++){
	cc_coef[i] = (Float *)mal1(LN2*sizeof(*cc_coef[0]));
	for(j=0; j<Chans; j++)
	    cc_gain[i][j] = (Float *)mal1(MAXBANDS*sizeof(*cc_gain[0][0]));
#if (ICChans > 0)
	if (i < ICChans) {
	    cc_state[i] = (Float *)mal1(LN*sizeof(*state[0]));  /* changed LN4 to LN 1/97 mfd */
	    fltclr(cc_state[i], LN);
	    cc_wnd_shape[i].prev_bk = 0;
	}
#endif
    }
#endif


#ifdef	SSR
	for(i = 0; i < Chans; i++){
		wnd_shape_SSR[i].prev_bk = 0;
	}
#endif
	for(i = 0; i < Chans; i++){
		wnd_shape[i].prev_bk = 0;
		wnd_shape[i].this_bk = 0;
	}


    initio(argc, argv);	    /* parse command line */
    restarttio();	    /* reset io counters  */

    if(!startblock())       /* read adif header   */
      myexit(0);

    init();		    /* initialize data structures */

    /* main loop */
    for(bno = 0;; bno++) {
	if(debug['n'])
	    PRINT(SE, "\rblock %ld", bno);

	byte_align();
	

	reset_mc_info(mip);
	while ((ele_id=getbits(LEN_SE_ID)) != ID_END) {
	    /* get audio syntactic element */

          if(debug['v'])
            PRINT(SE, "\nele_id %d\n", ele_id);

	    switch (ele_id) {
	    case ID_SCE:		/* single channel */
	    case ID_CPE:		/* channel pair */
	    case ID_LFE:		/* low freq effects channel */
		if (huffdecode(ele_id, mip, wnd, wnd_shape,
		    cb_map, factors, 
		    group, hasmask, mask, max_sfb,
		    lpflag, prstflag
#ifdef MPEG4V1
		    , nok_lt_status
#endif
		    , tns, coef) < 0)
		    myexit("huffdecode");
		break;
#if (CChans > 0)
	    case ID_CCE:		/* coupling channel */
		if (getcc(mip, cc_wnd, cc_wnd_shape, cc_coef, cc_gain) < 0)
		    myexit("getcc");
		break;
#endif				
	    case ID_DSE:		/* data element */
		if (getdata(&d_tag, &d_cnt, d_bytes) < 0)
		    myexit("data channel");
		break;
	    case ID_PCE:		/* program config element */
		get_prog_config(&prog_config);
		break;
	    case ID_FIL:		/* fill element */
		getfill();
		break;
	    default:
		PRINT(SE, "Element not supported: %d\n", ele_id);
		break;
	    }
	}
        if(debug['v'])
          PRINT(SE, "\nele_id %d\n", ele_id);
	check_mc_info(mip, (bno==0 && default_config));

	/* call transport layer */
	if(endblock() < 0)
	    myexit("endblock");

#if (ICChans > 0)
	/* transform independently switched coupling channels */
	ind_coupling(mip, wnd, wnd_shape, cc_wnd, cc_wnd_shape, cc_coef,
	    cc_state);
#endif	
    
	/* m/s stereo */
	for (ch=0; ch<Chans; ch++) {
	    cip = &mip->ch_info[ch];
	    if ((cip->present) && (cip->cpe) && (cip->ch_is_left)) {
		wn = cip->widx;
		if(hasmask[wn]) {
		    left = ch;
		    right = cip->paired_ch;
		    info = winmap[wnd[wn]];
                    if (hasmask[wn] == 1)
                        map_mask(info, group[wn], mask[wn], cb_map[right]);
		    synt(info, group[wn], mask[wn], coef[right], coef[left]);
		}
	    }
	}

	/* intensity stereo and prediction */
	for (ch=0; ch<Chans; ch++) {
	    if (!(mip->ch_info[ch].present)) continue;
	    wn = mip->ch_info[ch].widx;
	    info = winmap[wnd[wn]];
#ifdef MPEG4V1
            pns( mip, info, wn, ch,
                 group[wn], cb_map[ch], factors[ch], 
                 lpflag[wn], coef );
#endif
	    intensity(mip, info, wn, ch, 
		group[wn], cb_map[ch], factors[ch], 
		lpflag[wn], coef);
#ifndef MPEG4V1
	    predict(info, mip->profile, 
		lpflag[wn], sp_status[ch], coef[ch]);
#else
	    nok_lt_predict (mip->profile, info, wnd[ch], &wnd_shape[ch],
			    nok_lt_status[ch]->sbk_prediction_used,
			    nok_lt_status[ch]->sfb_prediction_used,
			    nok_lt_status[ch], nok_lt_status[ch]->weight,
			    nok_lt_status[ch]->delay, coef[ch],
			    BLOCK_LEN_LONG, 0, BLOCK_LEN_SHORT);
#endif
	}

	for (ch=0; ch<Chans; ch++) {
	    if (!(mip->ch_info[ch].present)) continue;
	    wn = mip->ch_info[ch].widx;
	    info = winmap[wnd[wn]];

#ifndef MPEG4V1
	    /* predictor reset */
	    left = ch;
	    right = left;
	    if ( (mip->ch_info[ch].cpe) &&
		(mip->ch_info[ch].common_window) )
		/* prstflag's shared by channel pair */
		right = mip->ch_info[ch].paired_ch;
	    predict_reset(info, prstflag[wn], sp_status, left, right);
#endif

#ifdef MPEG4V1
            /* PNS predictor reset */
            predict_pns_reset(info, sp_status[ch], cb_map[ch]);
#endif

#if (CChans > 0)
	    /* if cc_domain indicates before TNS */
	    coupling(info, mip, coef, cc_coef, cc_gain, ch, CC_DOM, !CC_IND);
#endif

	    /* tns */
	    for (i=j=0; i<tns[ch]->n_subblocks; i++) {
		if (debug['T']) {
		    PRINT(SE, "%ld %d %d\n", bno, ch, i);
		    print_tns( &(tns[ch]->info[i]));
		}

		tns_decode_subblock(&coef[ch][j],
		    max_sfb[wn],
		    info->sbk_sfb_top[i],
		    info->islong,
		    &(tns[ch]->info[i]) );

		j += info->bins_per_sbk[i];
	    }

#if (CChans > 0)
	    /* if cc_domain indicated after TNS */
	    coupling(info, mip, coef, cc_coef, cc_gain, ch, CC_DOM, !CC_IND);
#endif

#ifdef DOLBY_MDCT
	    /* inverse transform */
#ifdef  SSR
		wnd_shape_SSR[ch].this_bk = wnd_shape[wn].this_bk;

		if(mc_info.profile == SSR_Profile){
			gain_control(coef[ch], &wnd_shape_SSR[ch], wnd[wn], ch, data[ch]);
		}
		else{
			freq2time_adapt (wnd [wn], &wnd_shape_SSR[ch], coef [ch], state [ch], data [ch]);
		}

		wnd_shape_SSR[ch].prev_bk  = wnd_shape_SSR[ch].this_bk; 
#else
	    freq2time_adapt (wnd [wn], &wnd_shape [wn], coef [ch], state [ch], data [ch]);
#endif
#else 
	    imdct(wnd[wn], wnd_shape[wn].this_bk, coef[ch], state[ch], data[ch]);
	    {
		/* scale imdct output */
		Float scale = 1.0 / sqrt (2.0);
		for (i = 0; i < LN2; i++)
		    data[ch][i] *= scale;
	    }
#endif
#if (CChans > 0)
	    /* independently switched coupling */
	    coupling(info, mip, coef, cc_coef, cc_gain, ch, CC_DOM, CC_IND);
#endif
	}

	/* skip first two blocks so output is time aligned with input */
	if (bno > 1)
	    writeout(data, mip);
    }
}
