/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS and edited by
Yoshiaki Oikawa (Sony Corporation),
Mitsuyuki Hatanaka (Sony Corporation)
in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/
#include "all.h"

/*
 * read and decode the data for the next 1024 output samples
 * return -1 if there was an error
 */
int
huffdecode(int id, MC_Info *mip, byte *win, Wnd_Shape *wshape, 
    byte **cb_map, short **factors, 
    byte **group, byte *hasmask, byte **mask, byte *max_sfb, 
    int **lpflag, int **prstflag,
#ifdef MPEG4V1
    NOK_LT_PRED_STATUS **nok_ltp_status, 
#endif
    TNS_frame_info **tns, Float **coef)
{
    int i, tag, common_window, ch, widx, first=0, last=0;

    short global_gain;  /* not used in this routine */
    Info info;

    tag = getbits(LEN_TAG);

    switch(id) {
	case ID_SCE:
	case ID_LFE:
	    common_window = 0;
	    break;
	case ID_CPE:
	    common_window = getbits(LEN_COM_WIN);
	    break;
	default:
	    PRINT(SE,"Unknown id %d\n", id);
	    return(-1);
    }

    if ((ch = chn_config(id, tag, common_window, mip)) < 0)
	    return -1;
    
    switch(id) {
	case ID_SCE:
	case ID_LFE:
	    widx = mip->ch_info[ch].widx;
	    first = ch;
	    last = ch;
	    hasmask[widx] = 0;
	    break;
	case ID_CPE:
	    first = ch;
	    last = mip->ch_info[ch].paired_ch;
	    if (common_window) {
		widx = mip->ch_info[ch].widx;
		get_ics_info(&win[widx], &wshape[widx].this_bk, group[widx],
		    &max_sfb[widx], lpflag[widx], prstflag[widx]
#ifndef MPEG4V1
		    );
#else
		    ,nok_ltp_status[widx]);
                
                {
                  int paired_ch = mip->ch_info[ch].paired_ch;
                  
                  if(nok_ltp_status[widx]->global_pred_flag)
                  {
                    nok_ltp_status[paired_ch]->global_pred_flag = 
                        nok_ltp_status[widx]->global_pred_flag;
                    for(i = 0; i < NOK_MAX_BLOCK_LEN_LONG; i++)
                      nok_ltp_status[paired_ch]->pred_mdct[i] = 
                          nok_ltp_status[widx]->pred_mdct[i];
                    for(i = 0; i < MAX_SCFAC_BANDS; i++)
                      nok_ltp_status[paired_ch]->sfb_prediction_used[i] = 
                          nok_ltp_status[widx]->sfb_prediction_used[i];
                    nok_ltp_status[paired_ch]->weight = nok_ltp_status[widx]->weight;
                    nok_ltp_status[paired_ch]->delay[0] = nok_ltp_status[widx]->delay[0];
                  }
                }
#endif
		hasmask[widx] = getmask(winmap[win[widx]], group[widx], 
		    max_sfb[widx], mask[widx]);
	    }
	    else { 
		hasmask[mip->ch_info[first].widx] = 0;
		hasmask[mip->ch_info[last].widx] = 0;
	    }
	    break;
    }

    if(debug['v']) {
	PRINT(SE,"tag %d, common window %d\n", tag, common_window);
	PRINT(SE,"nch %d, channels %d %d, widx %d %d\n",
	    last-first+1, first, last, 
	    mip->ch_info[first].widx, mip->ch_info[last].widx);
    }

    for (i=first; i<=last; i++) {
	widx = mip->ch_info[i].widx;
	fltclr(coef[i], LN2);

	if(!getics(&info, common_window, &win[widx], &wshape[widx].this_bk,
	    group[widx], &max_sfb[widx], lpflag[widx], prstflag[widx], 
	    cb_map[i], coef[i], &global_gain, factors[i],
#ifdef MPEG4V1
	    nok_ltp_status[widx],
#endif
	    tns[i]
#ifdef  SSR
            , i
#endif
	   ))
	    return -1;
    }
    return 0;
}

void
get_ics_info(byte *win, byte *wshape, byte *group,
byte *max_sfb, int *lpflag, int *prstflag
#ifdef MPEG4V1
, NOK_LT_PRED_STATUS *nok_ltp_status
#endif
)
{
    int i, j;
    int max_pred_sfb = pred_max_bands();
    Info *info;

    getbits(LEN_ICS_RESERV);	    /* reserved bit */
    *win = getbits(LEN_WIN_SEQ);
    *wshape = getbits(LEN_WIN_SH);
    if ((info = winmap[*win]) == NULL)
        myexit("bad window code");
	
    /*
     * max scale factor, scale factor grouping and prediction flags
     */
    prstflag[0] = 0;
    if (info->islong) {
	*max_sfb = getbits(LEN_MAX_SFBL);
	group[0] = 1;
#ifndef MPEG4V1
	if ((lpflag[0] = getbits(LEN_PRED_PRES))) {
	    if ((prstflag[0] = getbits(LEN_PRED_RST))) {
		for(i=1; i<LEN_PRED_RSTGRP+1; i++)
		    prstflag[i] = getbits(LEN_PRED_RST);
	    }
	    j = ( (*max_sfb < max_pred_sfb) ? 
	        *max_sfb : max_pred_sfb ) + 1;
	    for (i = 1; i < j; i++)
		lpflag[i] = getbits(LEN_PRED_ENAB);
	    for ( ; i < max_pred_sfb+1; i++)
		lpflag[i] = /* 0 */ 1 /* SRQ FIX!!!! */;
	}
#else
	nok_lt_decode(*win, *max_sfb,
		      nok_ltp_status->sbk_prediction_used,
		      nok_ltp_status->sfb_prediction_used,
		      &nok_ltp_status->weight,
		      nok_ltp_status->delay);
#endif
    }
    else {
	*max_sfb = getbits(LEN_MAX_SFBS);
	getgroup(info, group);
	lpflag[0] = 0;
#ifdef MPEG4V1
	nok_ltp_status->sbk_prediction_used[0] = 0;
#endif
    }

    if(debug['v']) {
	PRINT(SE,"win %d, wsh %d\n", *win, *wshape);
	PRINT(SE,"max_sf %d\n", *max_sfb);
    }

    if (debug['p']) {
	if (lpflag[0]) {
	    PRINT(SE,"prediction enabled (%2d):  ", *max_sfb);
	    for (i=1; i<max_pred_sfb+1; i++)
		PRINT(SE," %d", lpflag[i]);
	   PRINT(SE,"\n");
	}
    }
}
