//////////////////////////////////////////////////////////////////////
// draw.c - Ghetto War drawing code
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <noflick.h>

#include "data.h"
#include "gwar.h"

#include "ostats.h"

#include "draw.h"
#include "palcols.h"

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int setupBackground(void) {
int err = 0, count, rock;
BITMAP *nasty;

   clear(double_buffer);

   for (count = 0; count < NUM_STARS; count++) {
       putpixel(double_buffer, rand()%SCREEN_W, rand()%SCREEN_H, STAR_COLOR_END-(rand()%STAR_COLOR_NUM));
       // Just draw some pixels, like stars (shabby, but ok :)
   } // for count

   for (count = 0; count < NUM_ROCKS; count++) {
       rock = ROCK000 + (rand()%12);
       nasty = (BITMAP *)(dataFile[rock].dat);

//       rotate_sprite(double_buffer, nasty, (rand()%SCREEN_W)-(nasty->w/2), (rand()%SCREEN_H)-(nasty->h/2), itofix(rand()%256));

      draw_sprite(double_buffer, nasty, (rand()%SCREEN_W)-(nasty->w/2), (rand()%SCREEN_H)-(nasty->h/2));

   } // for count

// end setupBackground
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void makeExplosions(void) {
BITMAP *bmp = create_bitmap(EXPLODE_SIZE, EXPLODE_SIZE);
unsigned char *p;
int c, c2;
int x, y;
int xx, yy;
int color;

   #define HOTSPOTS  64

   struct HOTSPOT {
      int x, y;
      int xc, yc;
   } hot[HOTSPOTS];

   for (c=0; c<HOTSPOTS; c++) {
      hot[c].x = hot[c].y = (EXPLODE_SIZE/2)<<16;
      hot[c].xc = (rand()&0xFFFF)-0x7FFF;
      hot[c].yc = (rand()&0xFFFF)-0x7FFF;
   }

   for (c=0; c<NUM_EXPLO_FRAMES; c++) {
      clear(bmp);

      color = ((c<16) ? c*4 : (80-c)) >> 2;

      for (c2=0; c2<HOTSPOTS; c2++) {
	       for (x=-6; x<=6; x++) {
	           for (y=-6; y<=6; y++) {
	               xx = (hot[c2].x>>16) + x;
	               yy = (hot[c2].y>>16) + y;
	               if ((xx>0) && (yy>0) && (xx<EXPLODE_SIZE) && (yy<EXPLODE_SIZE)) {
		               p = bmp->line[yy] + xx;
		               *p += (color >> ((ABS(x)+ABS(y))/3));
		               if (*p > 63)
		                  *p = 63;
                  }
              }
          }
	       hot[c2].x += hot[c2].xc;
	       hot[c2].y += hot[c2].yc;
      }

      for (x=0; x<EXPLODE_SIZE; x++) {
	       for (y=0; y<EXPLODE_SIZE; y++) {
	           c2 = bmp->line[y][x];
	           if (c2 < 8)
	              bmp->line[y][x] = 0;
              else
	               bmp->line[y][x] = 226+c2/4;
          }
      }

      explosion[c] = get_rle_sprite(bmp);
   }

   destroy_bitmap(bmp);
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void freeExplosions(void) {
int i;

   for (i = 0; i < NUM_EXPLO_FRAMES; i++) {
       destroy_rle_sprite(explosion[i]);

   } // for i

// end freeExplosions
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void drawStats(void) {
int color, x, w, h;
char mook[20];
RLE_SPRITE *nasty;

   if (!player1 || !player2) {
      nasty = (RLE_SPRITE *)dataFile[RESPAWN_NOTICE].dat;
      x = (SCREEN_W - nasty->w)/2;
      ff_pushDrawn(x, SCREEN_H-100, nasty->w, nasty->h);
      draw_rle_sprite(double_buffer, nasty, x, SCREEN_H-100);
   }

   x = SCREEN_W - 100;
   h = (2*text_height(font))+1;
   ff_pushDrawn(x, 0, 100, h);
   textout(double_buffer, font, "Player 1", x, 0, BRIGHT_WHITE);
   strcpy(mook, "Kills: ");
   itoa(player1Kills, &mook[7], 10);
   textout(double_buffer, font, mook, x, text_height(font)+1, BRIGHT_WHITE);

   if (player1) {
      if (player1->health > 0) {
         if (player1->health < 16)
            color = BRIGHT_RED;
         else if (player1->health < 32)
              color = BRIGHT_YELLOW;
         else color = BRIGHT_BLUE;

         ff_pushDrawn(x, h+1, player1->health+1, 10);
         rectfill(double_buffer, x, h+1, x+player1->health, h+10, color);
      } // postive health
   } // if player 1

   h = SCREEN_H - (2*(text_height(font)+1)) - 10;
   ff_pushDrawn(0, h, 100, (2*text_height(font))+1);
   textout(double_buffer, font, "Player 2", 0, h, BRIGHT_GREEN);
   itoa(player2Kills, &mook[7], 10);
   textout(double_buffer, font, mook, 0, h+text_height(font)+1, BRIGHT_GREEN);
   if (player2) {
      if (player2->health > 0) {
         if (player2->health < 30)
            color = BRIGHT_RED;
         else if (player2->health < 60)
              color = BRIGHT_YELLOW;
         else color = BRIGHT_BLUE;

         ff_pushDrawn(0, SCREEN_H-10, player2->health+1, 10);
         rectfill(double_buffer, 0, SCREEN_H-10, player2->health, SCREEN_H, color);
      } // postive health
   } // if player 2

// end drawStats
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int takeScreenShot(void) {
int err = 0, i;
char filename[80];
BITMAP *bmp;

   for (i = 0; i < 10000; i++) { // No one's ever gonna take that many pictures :)
       strcpy(filename, "gwar");
       itoa(i, &filename[4], 10);
       strcat(filename, ".bmp");

       if (!__file_exists(filename))
          break;

   } // for i

   bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
   err = save_bitmap(filename, bmp, dataFile[GAME_PALETTE].dat);
   destroy_bitmap(bmp);

// end takeScreenShot
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void doPause(void) {
int x, y;
RLE_SPRITE *nasty;
unsigned long time;

   time = gameTime;

   clear_keybuf();   // So it does actualyl pause

   nasty = (RLE_SPRITE *)dataFile[PAUSED_SIGN].dat;

   x = (SCREEN_W-nasty->w)/2;
   y = (SCREEN_H-nasty->h)/2;

   ff_pushDrawn(x, y, nasty->w, nasty->h);
   draw_rle_sprite(screen, nasty, x, y);
   // Only put it to screen, so we don't have to call the screen update routines.
   // However, still have to push a rect so that it gets erased.

   while (!keypressed())
         ;

   clear_keybuf();   // So nothing bad happens

   gameTime = time;

// end doPause
}

