//////////////////////////////////////////////////////////////////////
// gwar.c - Main code for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <math.h>

#include <allegro.h>
#include <noflick.h>

#include "data.h"
#include "gwar.h"
#include "draw.h"
#include "ostats.h"

DATAFILE *dataFile;
RLE_SPRITE *explosion[NUM_EXPLO_FRAMES];
char gameDone = 0;
volatile unsigned long gameTime;
double sinTable[257], cosTable[257];

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

void incGameTime(void) {   // This has to be declared here so it can be
                           // locked later. I'm not sure if you can call
                           // LOCK_FUNCTION right after END_OF_FUNCTION

   gameTime++;

// end incGameTime
}
END_OF_FUNCTION(incGameTime);

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[]) {
int err = 0;

   if (!setup(argc, argv)) {

      if (!(player1=pushObject(PLAYER1, 3*GAME_GRID_W/4, GAME_GRID_H/2, UP_DIR)))
         err = -1;

      if (!(player2=pushObject(PLAYER2, GAME_GRID_W/4, GAME_GRID_H/2, DOWN_DIR)))
         err = -1;

      gameTime = 0;
      while (!gameDone && !err) {

         err = ff_eraseScreen();
         if (err)
            continue;

         worldThink();
         objectThinks();
         objectTouches();

         drawObjects();
         drawStats();

         err = ff_updateScreen();
         if (err)
            continue;

      } // !gameDone

   } // !setup

   shutdown();

// end main
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void worldThink(void) {

   if (key[KEY_SPACE]) {
      if (!player1)
         player1 = pushObject(PLAYER1, rand()%GAME_GRID_W, rand()%GAME_GRID_H, rand()%256);

      if (!player2)
         player2 = pushObject(PLAYER2, rand()%GAME_GRID_W, rand()%GAME_GRID_H, rand()%256);

   } // space hit

   if (key[KEY_ESC])
      gameDone = 1;

   if (key[KEY_F12])
      takeScreenShot();

   if (key[KEY_P])
      doPause();

// end worldThink
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int setup(int argc, char *argv[]) {
int err = 0, i;
char filename[80];

   allegro_init();

   install_keyboard();
   clear_keybuf();      // Again, why do I have to do this? Never had that trouble before

   install_timer();

   LOCK_VARIABLE(gameTime);   // System stuff
   LOCK_FUNCTION(incGameTime);
   install_int(incGameTime, GAME_TIME_BASE);  // Set it up according to GAME_TIME_BASE

   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) < 0) {
      printf("Warning, you have no sound... Press a key\n");
      readkey();
   }

   if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0) {
      printf("Could not set video mode. Try getting UnivBe\n");
      printf("Allegro error: %s\n", allegro_error);
      return -1;
   }

   text_mode(-1);

   if (err = ff_setup(SCREEN_W, SCREEN_H)) {
      fprintf(stderr, "Error in flicker free setup.\n");
      return err;
   }

   strcpy(filename, argv[0]);
   strcpy(get_filename(filename), "gwar.dat");
   dataFile = load_datafile(filename);
   if (!dataFile) {
      allegro_exit();
      printf("Could not open gwar.dat\n");
      return -2;
   } // !dataFile

   srand(time(NULL));

   if (err = statsInit())
      return err;

   for (i = 0; i <= 256; i++) {
       sinTable[i] = sin(PI * i / 128);
       cosTable[i] = cos(PI * i / 128);
   }
   // These are needed because of inaccuracies with sin() and cos() at these angles:
      sinTable[UP_DIR] = -1;
      cosTable[UP_DIR] = 0;

      sinTable[DOWN_DIR] = 1;
      cosTable[DOWN_DIR] = 0;

      sinTable[LEFT_DIR] = 0;
      cosTable[LEFT_DIR] = -1;

      sinTable[RIGHT_DIR] = 0;
      cosTable[RIGHT_DIR] = 1;

      sinTable[DRIGHT_DIR] = 0;
      cosTable[DRIGHT_DIR] = 1;
   //////////

   player1 = player2 = NULL;

   set_palette(dataFile[GAME_PALETTE].dat);

   makeExplosions();
   setupBackground();
//   blit(double_buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   ff_drawDB();
   // Done here and not in bkgnd setup in case there's other stuff we want to do

// end setup
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void shutdown(void) {

   freeExplosions();

   statsKill();

   ff_shutdown();

   if (set_gfx_mode(GFX_TEXT, 80, 24, 0, 0) < 0) {
      printf("Could not set text mode! What the hell???\n");
      printf("Allegro error: %s\n", allegro_error);
      return;
   }

   unload_datafile(dataFile);

   clear_keybuf();   // Why do I have to do this???

// end shutdown
}

