//////////////////////////////////////////////////////////////////////
// objai.c - Object AI code for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include <allegro.h>
// #include <noflick.h>

#include "gwar.h"
#include "data.h"

#include "ostats.h"
#include "objs.h"
#include "objai.h"

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int rotx(int x, int y, int angle) {
int newX;

   newX = (x * cosTable[angle]) - (y * sinTable[angle]);

// end rotx
return newX;
}

//////////////////////////////////////////////////////////////////////
int roty(int x, int y, int angle) {
int newY;

   newY = (y * cosTable[angle]) + (x * sinTable[angle]);

// end roty
return newY;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void moveAlong(objPtr me) {

   me->x += cosTable[me->angle] * me->speed;
   me->y += sinTable[me->angle] * me->speed;

   if (me->x < GG_LBORDER)
      me->x += GG_RBORDER;
   else if (me->x > GG_RBORDER)
        me->x -= GG_RBORDER;

   if (me->y < GG_TBORDER)
      me->y += GG_BBORDER;
   else if (me->y > GG_BBORDER)
        me->y -= GG_BBORDER;

// end moveAlong
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void player1Think(objPtr me) {

      if (me->health <= 0) {
         player2Kills++;
         player1 = NULL;
         killObject(me);
         return;
      }

//   player1 = me;
   me->currFrame = SHIP0;

   if (key[KEY_LEFT])
      me->angle = (me->angle-4) & 255;

   if (key[KEY_RIGHT])
      me->angle = (me->angle+4) & 255;

   if (key[KEY_UP]) {
      me->currFrame = SHIP1;
      if ((me->speed+=2) >= 50)
         me->speed = 50;
//      play_sample(dataFile[ENGINE_NOISE].dat, 255, 128, 1000, 0);
   }

   if (key[KEY_DOWN]) {
      me->currFrame = SHIP1;
      if ((me->speed-=2) <= -50)
         me->speed = -50;
//      play_sample(dataFile[ENGINE_NOISE].dat, 255, 128, 1000, 0);
   }

   if (key[KEY_RCONTROL] && (gameTime - me->lastShot) > me->fireDelay) {
                         // Notice that I pushed the shots in a little (they angle towards
                         // each other slightly). Also remember the rotations have to be in
                         // game units (10 per pixel)
      if (!pushObject(PLAYER1_SHOT, me->x + rotx(60, 140, me->angle), me->y + roty(60, 140, me->angle), (me->angle-1)&255))
         return;
      if (!pushObject(PLAYER1_SHOT, me->x + rotx(60, -140, me->angle), me->y + roty(60, -140, me->angle), (me->angle+1)&255))
         return;
      play_sample(dataFile[P1SHOT_SOUND].dat, 255, PAN(me->x), 1000, 0);
      me->lastShot = gameTime;
   }

   moveAlong(me);

// end player1Think
}

//////////////////////////////////////////////////////////////////////
int player1ShipTouch(objPtr me, objPtr atkr) {

   if (atkr->type != PLAYER1 && atkr->type != PLAYER1_SHOT) {
      // Don't shoot yourself or your
      // own bullets :)
//      me->health -= atkr->damage;
      atkr->health -= me->damage;
   }

// end player1ShipTouch
return 0;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void player1ShotThink(objPtr me) {

   if (gameTime - me->created > 500) {
      if (gameTime - me->created > 750) {
         popObject(me); // Watch it, don't do anything after this pop
         return;
      } else
          me->currFrame = P1SHOT1;  // fade the shot out a little
   }

   moveAlong(me);

// end player1ShotThink
}

//////////////////////////////////////////////////////////////////////
int player1ShotTouch(objPtr me, objPtr atkr) {

   if (atkr->type != PLAYER1 && atkr->type != PLAYER1_SHOT) {
      // Don't shoot yourself or your
      // own bullets :)
      atkr->health -= me->damage;
      killObject(me);
      return 1;
   }

// end player1ShotTouch
return 0;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void player2Think(objPtr me) {

      if (me->health <= 0) {
         player1Kills++;
         player2 = NULL;
         killObject(me);
         return;
      }

//   player2 = me;
   me->currFrame = P2SHIP0;

   if (key[KEY_F])
      me->angle = (me->angle-2) & 255;

   if (key[KEY_H])
      me->angle = (me->angle+2) & 255;

   if (key[KEY_T]) {
      me->currFrame = P2SHIP1;
      if ((me->speed+=1) >= 38)
         me->speed = 38;
//      play_sample(dataFile[ENGINE_NOISE].dat, 255, 128, 1000, 0);
   }

   if (key[KEY_G]) {
      me->currFrame = P2SHIP1;
      if ((me->speed-=1) <= -38)
         me->speed = -38;
//      play_sample(dataFile[ENGINE_NOISE].dat, 255, 128, 1000, 0);
   }

   if (key[KEY_LCONTROL] && (gameTime - me->lastShot) > me->fireDelay) {
                         // Notice that I pushed the shots in a little (they angle towards
                         // each other slightly). Also remember the rotations have to be in
                         // game units (10 per pixel)
      if (!pushObject(PLAYER2_SHOT, me->x + rotx(160, 0, me->angle), me->y + roty(160, 0, me->angle), me->angle))
         return;
      play_sample(dataFile[P2SHOT_SOUND].dat, 255, PAN(me->x), 1000, 0);
      me->lastShot = gameTime;
   }

   moveAlong(me);

// end player2Think
}

//////////////////////////////////////////////////////////////////////
int player2ShipTouch(objPtr me, objPtr atkr) {

   if (atkr->type != PLAYER2 && atkr->type != PLAYER2_SHOT) {
      // Don't shoot yourself or your
      // own bullets :)
//      me->health -= atkr->damage;
      atkr->health -= me->damage;

//      fprintf(stderr, "atkrD=%i\n", atkr->damage);
   }

// end player2ShipTouch
return 0;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void player2ShotThink(objPtr me) {

   if (gameTime - me->created > 800) {
      if (gameTime - me->created > 1200) {
         popObject(me); // Watch it, don't do anything after this pop
         return;
      } else
          me->currFrame = P2SHOT1;  // fade the shot out a little
   }

   moveAlong(me);

// end player2ShotThink
}

//////////////////////////////////////////////////////////////////////
int player2ShotTouch(objPtr me, objPtr atkr) {

   if (atkr->type != PLAYER2 && atkr->type != PLAYER2_SHOT) {
      // Don't shoot yourself or your
      // own bullets :)
      atkr->health -= me->damage;
      killObject(me);
      return 1;
   }

// end player2ShotTouch
return 0;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void shotDeath(objPtr me) {

//   play_sample(dataFile[SMALL_EXPLOSION].dat, 255, PAN(me->x), 1000, 0);

// end shotDeath
}

//////////////////////////////////////////////////////////////////////
void shipDeath(objPtr me) {
objPtr p;

   p = pushObject(EXPLOSION, me->x, me->y, me->angle);
   if (!p)
      return;
   p->speed = me->speed / 1.5;

   play_sample(dataFile[BIG_EXPLOSION].dat, 255, PAN(me->x), 1000, 0);

// end shipDeath
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void explosionThink(objPtr me) {
int t;

   me->currFrame++;
   if (me->currFrame >= NUM_EXPLO_FRAMES) {
      popObject(me);
      return;
   }

   moveAlong(me);

// end explosionThink
}

