//////////////////////////////////////////////////////////////////////
// ostats.c - Object Stat code for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include <allegro.h>

#include "palcols.h"

#include "gwar.h"
#include "ostats.h"
#include "objs.h"

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
objStatPtr stats;
objList objects;
objPtr player1, player2;
int player1Kills = 0, player2Kills = 0;
    // Initialization to 0 is redundat because they're global, but keep it clean, eh? :)

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int statsInit(void) {
int err = 0;

   stats = malloc(sizeof(objStat) * NUM_OBJECT_TYPES);
   if (!stats) {
      fprintf(stderr, "Not enough memory for object stats.\n");
      return -1;
   }

   stats[PLAYER1].initFunc = initPlayer1;
   stats[PLAYER1_SHOT].initFunc = initPlayer1Bullet;
   stats[PLAYER2].initFunc = initPlayer2;
   stats[PLAYER2_SHOT].initFunc = initPlayer2Bullet;
   stats[4].initFunc = initExplosion;

   objects.front = objects.rear = NULL;

// end statsInit
return err;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void statsKill(void) {

   while (objects.front)
         popObject(objects.rear);

   free(stats);

// end statsKill
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
objPtr pushObject(int type, int x, int y, int angle) {
objPtr p;

//   fprintf(stderr, "make object %i, %i, %i, %i\n", type, x, y, angle);

   p = malloc(sizeof(object));
   if (!p) {
      fprintf(stderr, "Not enough memory for object\n");
      return NULL;
   }

   p->last = objects.rear;
   if (objects.rear)
      objects.rear->next = p;
   else
       objects.front = p;

   objects.rear = p;
   p->next = NULL;

   p->type = type;   // Needed for collision, to tell what hit you
   if ((*stats[type].initFunc)(p, x, y, angle)) {
      return NULL;   // Just bomb out
   }
   p->created = gameTime;
   p->lastThink = gameTime - p->thinkTime;   // Make him think right away
   p->lastShot = gameTime - p->fireDelay;    // Make him ready to fire right away :)

// end pushObject
return p;
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void popObject(objPtr who) {

   if (who->next)
      who->next->last = who->last;
   else objects.rear = who->last;

   if (who->last)
      who->last->next = who->next;
   else objects.front = who->next;

   free(who);

// end popObject
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void killObject(objPtr who) {

   if (who->deathFunc)
      (*who->deathFunc)(who);

   popObject(who);

// end killObject
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void drawObjects(void) {
objPtr p;

   p = objects.front;
   while (p) {

      if (p->drawFunc)
         (*p->drawFunc)(p);

      p = p->next;
   }     // while p

// end drawObjects
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void objectThinks(void) {
objPtr p, next;

   p = objects.front;
   while (p) {

      next = p->next;   // This is in case the object removes itself during the game.
                        // Of course, if this is the last object in the list and it creates
                        // a new object during its think, that object's think can not
                        // be executed until the next pass because next will still be NULL,
                        // but no one's going to notice. Trust me :)

      if (p->thinkFunc && (gameTime-p->lastThink) > p->thinkTime) {
         (*p->thinkFunc)(p);
//         objectTouch(p);
         p->lastThink = gameTime;
      }

      p = next;
   }     // while p

// end objectThinks
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int objCollide(objPtr obj1, objPtr obj2) {
long x, y;

   x = (obj2->x-obj1->x)*(obj2->x-obj1->x);
   y = (obj2->y-obj1->y)*(obj2->y-obj1->y);

//   fprintf(stderr, "(x, y):(%i, %i); (r, r):(%i, %i)\n", x, y, obj1->radius, obj2->radius);

   if ((x+y) < (obj1->radius + obj2->radius))
      return 1;

/*
   // This system of collision detection has some flaws, as discussed on the AGP mailing
   // list, but I doubt they'll ever. come up

   // We're going to cycle through obj2's bbox points and test them in obj1's box

   // Right here we're rotating the first obj2 point according to obj2's orientation

   vline(screen, obj2->x/GAME_GRID_SIZE, 0, SCREEN_H, BRIGHT_GREEN);
   hline(screen, 0, obj2->y/GAME_GRID_SIZE, SCREEN_W, BRIGHT_GREEN);
//   readkey();

   x = rotx(obj2->bbox[0].x, obj2->bbox[0].y, obj2->angle);
   y = roty(obj2->bbox[0].x, obj2->bbox[0].y, obj2->angle);

   // Now I'm going to make it relative to obj1
   x += obj2->x;
   y += obj2->y;
//   vline(screen, x/GAME_GRID_SIZE, 0, SCREEN_H, BRIGHT_BLUE);
//   hline(screen, 0, y/GAME_GRID_SIZE, SCREEN_W, BRIGHT_BLUE);

   x -= obj1->x;
   y -= obj1->y;

//   vline(screen, (obj1->x+x)/GAME_GRID_SIZE, 0, SCREEN_H, BRIGHT_BLUE);
//   hline(screen, 0, (obj1->y+y)/GAME_GRID_SIZE, SCREEN_W, BRIGHT_BLUE);
//   readkey();

   // Now we're going to rotate that by the converse of obj1's angle
   // Basically, we're making it so everything faces to the right
   x = rotx(x, y, 256-obj1->angle);
   y = roty(x, y, 256-obj1->angle);

   vline(screen, (obj1->x+x)/GAME_GRID_SIZE, 0, SCREEN_H, BRIGHT_RED);
   hline(screen, 0, (obj1->y+y)/GAME_GRID_SIZE, SCREEN_W, BRIGHT_RED);
   sprintf(mook, "%i", obj1->type);
   textout(screen, font, mook, (x+obj1->x)/GAME_GRID_SIZE, (y+obj1->y)/GAME_GRID_SIZE, BRIGHT_WHITE);

//   readkey();

//   vline(screen, x, 0, SCREEN_H, BRIGHT_RED);
//   hline(screen, 0, y, SCREEN_W, BRIGHT_RED);

   // Now test to see if that is in obj1's bbox. Bbox looks like so:
   //     0
   //      -------
   //      |     |
   //      |     |
   //      |     |
   //      -------
   //             1
   // That's how the corners are played out
   rect(screen, (obj1->bbox[0].x+obj1->x)/GAME_GRID_SIZE, (obj1->bbox[0].y+obj1->y)/GAME_GRID_SIZE,
                (obj1->bbox[1].x+obj1->x)/GAME_GRID_SIZE, (obj1->bbox[1].y+obj1->y)/GAME_GRID_SIZE, BRIGHT_WHITE);
//   readkey();

   if (x >= (obj1->bbox[0].x) && y >= (obj1->bbox[0].y) &&
      x <= (obj1->bbox[1].x) && y <= (obj1->bbox[1].y))
        return 1;

   // And now repeat!!! (I would assume this is faster than looping, and it saves an
   // infintessimal amount of memory :) It'll just be a bitch to change if I have to :)

   // Top right corner
   x = rotx(obj2->bbox[1].x, obj2->bbox[0].y, obj2->angle);
   y = roty(obj2->bbox[1].x, obj2->bbox[0].y, obj2->angle);
   x = rotx(x, y, 255-obj1->angle);
   y = roty(x, y, 255-obj1->angle);
   if (x >= (obj1->bbox[0].x+obj1->x) && y >= (obj1->bbox[0].y+obj1->y) &&
      x <= (obj1->bbox[1].x+obj1->x) && y <= (obj1->bbox[1].y+obj1->y))
        return 1;

   // Bottom right corner
   x = rotx(obj2->bbox[1].x, obj2->bbox[1].y, obj2->angle);
   y = roty(obj2->bbox[1].x, obj2->bbox[1].y, obj2->angle);
   x = rotx(x, y, 255-obj1->angle);
   y = roty(x, y, 255-obj1->angle);
   if (x >= (obj1->bbox[0].x+obj1->x) && y >= (obj1->bbox[0].y+obj1->y) &&
      x <= (obj1->bbox[1].x+obj1->x) && y <= (obj1->bbox[1].y+obj1->y))
        return 1;

   // Bottom left corner
   x = rotx(obj2->bbox[0].x, obj2->bbox[1].y, obj2->angle);
   y = roty(obj2->bbox[0].x, obj2->bbox[1].y, obj2->angle);
   x = rotx(x, y, 255-obj1->angle);
   y = roty(x, y, 255-obj1->angle);
   if (x >= (obj1->bbox[0].x+obj1->x) && y >= (obj1->bbox[0].y+obj1->y) &&
      x <= (obj1->bbox[1].x+obj1->x) && y <= (obj1->bbox[1].y+obj1->y))
        return 1;

   // Let's all pray to god this works! Yeehaw!

   // Of course as soon as I said it'd be a bitch to change and had copied it all out, I
   // had to change part :) Booo! Damn jinxes :)

*/

// end objCollide
return 0;
}

//////////////////////////////////////////////////////////////////////
void objectTouch(objPtr p) {
objPtr atkr;

      atkr = objects.front;
      while (atkr) {

            if (atkr != p) {
               if (objCollide(p, atkr)) {

//                  fprintf(stderr, "hit!\n");

                  if (p->touchFunc) {
                     if ((*p->touchFunc)(p, atkr))
                        return;
                  }

               } // they hit
            } // They aren't the same

            atkr = atkr->next;
      }

// end objectTouch
}

//////////////////////////////////////////////////////////////////////
void objectTouches(void) {
objPtr p, next;

      p = objects.front;
      while (p) {
            next = p->next;

            objectTouch(p);

            p = next;
      }

// end objectTouches
}

