//////////////////////////////////////////////////////////////////////
// ostats.h - Object Stat code header for Ghetto War
// Copyright Joe Kopena 1998
//////////////////////////////////////////////////////////////////////

#ifndef OBJECT_STATS
#define OBJECT_STATS

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
#define NUM_OBJECT_TYPES              5

#define OBJ_INIT_ARGS      objPtr me, int x, int y, int angle

// These are the object type numbers. They're in this file mostly to keep includes down
#define PLAYER1               0
#define PLAYER1_SHOT          1
#define PLAYER2               2
#define PLAYER2_SHOT          3
#define EXPLOSION             4

#define PLAYER1_HEALTH        50
#define PLAYER2_HEALTH        100

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
typedef struct coordTyp coord, *coordPtr;
struct coordTyp {
       int x, y; // Haha, so simple :)

}; // coordTyp

//////////////////////////////////////////////////////////////////////
typedef struct objTyp object, *objPtr;
struct objTyp {

   int x, y,   // Position (on game grid)
       speed, // How fast he's moving
       thinkTime, // How long between thinkFunc executions
       angle,
       fireDelay, // This isn't really needed, but is mostly so you can fire right away
                  // if you're holding down the fire key right after you're created
       health,    // Basically hit points
       damage;     // How much damage to do on collision
   char currFrame,  // Which index into the datafile to draw
        type;       // The object's type

//   coord bbox[2]; // The bounding box :)

   int radius;   // bounding circle radius (squared)

   unsigned long lastThink,   // Last time think func was executed
                 created,     // When object was created
                 lastShot;    // When you last fired

   void (*thinkFunc)(objPtr me);
   void (*deathFunc)(objPtr who);
   void (*drawFunc)(objPtr me);
   int (*touchFunc)(objPtr me, objPtr atkr); // These should not remove the object

   objPtr next, last;

}; // objTyp

typedef struct objListTyp objList, *objListPtr;
struct objListTyp {

   objPtr front, rear;

}; // objListTyp

typedef struct objStatTyp objStat, *objStatPtr;
struct objStatTyp {

   int (*initFunc)(OBJ_INIT_ARGS);   // Note that even if I decide to use the array instead of
                                 // linked list, this can still work, but calling it with
                                 // the address in the list: &objList[newObjNum] or whatever

}; // objStatTyp

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
extern objStatPtr stats;
extern objList objects;

extern objPtr player1, player2;
extern int player1Kills, player2Kills;

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
int statsInit(void);
void statsKill(void);

objPtr pushObject(int type, int x, int y, int angle);
void popObject(objPtr who);
void killObject(objPtr who);

void drawObjects(void);
void objectThinks(void);

int objCollide(objPtr obj1, objPtr obj2);
void objectTouch(objPtr p);

#endif // OBJECT_STATS

