////////////////////////////////////////////////////////////
// comp.c - BC computer AI code!
// Copyright Joe Kopena 1998
////////////////////////////////////////////////////////////

#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include <noflick.h>

#include "data.h"
#include "vars.h"
#include "game.h"
#include "colors.h"

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int firstShot(void);
int recalcShot(void);
unsigned long guessTripTime(fixed angle);
fixed guessBestAngle(void);
void getCompDir(void);
float guessBestVel(fixed angle, unsigned long tripTime);

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
playerBoxPtr comp;
int dirToTarget, compSide;
char numLookForward;

/*//////////////////////////////////////////////////////////
 if this is your first shot
    get the angle you have to shoot to clear your buildings
    get the angle you have to shoot to clear his buildings
    pick the steeper one

//////////////////////////////////////////////////////////*/

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int doCompTurn(void) {
int res;

   #ifdef DEBUG
          fprintf(stderr, "\n============== Computer's Turn! ================\n");
   #endif // DEBUG

   comp = &player[currPlayer];
   getCompDir();
   numLookForward = 12;  // reset this depending on difficulty!

   if (numTurns < 2) { // First shot!
      firstShot();
   } else {
     recalcShot();
   }

   #ifdef DEBUG
          fprintf(stderr, "fired at %f degrees, %f velocity\n", fixtof(comp->angle), comp->velocity);
   #endif // DEBUG

   res = fireShot();
   comp->lastHitType = cRes;  // res doe snot return shot hit type!
   comp->lastHitX = cx;
   comp->lastHitY = cy;
   comp->lastMinDist = minDistance;
   comp->lastMinX = minX;
   comp->lastMinY = minY;

   #ifdef DEBUG
          fprintf(stderr, "============ End Computer's Turn! ==============\n\n");
   #endif // DEBUG

// end doCompTurn
return res;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int firstShot(void) {
fixed gAngle;
float gVel;

   gAngle = guessBestAngle();
   gVel = guessBestVel(gAngle, guessTripTime(gAngle));

   if (gVel > MAX_VELOCITY) {
      gAngle += (10 * (gVel / MAX_VELOCITY)) * dirToTarget;
      comp->velocity = MAX_VELOCITY;
   }

   comp->angle = gAngle;
   comp->velocity = gVel;

// end firstShot
return 0;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int recalcShot(void) {
fixed angle;
float vel;
int ey, ex, sy;
char upDown;

   vel = comp->velocity;
   angle = comp->angle;

   ex = (comp->target->column*COLUMN_WIDTH) + 2 + ((COLUMN_WIDTH-4)/2);
   ey = (map[comp->target->column].h-5);

   sy = (map[comp->column].h-5);

   switch (comp->lastHitType) {
          case OFF_SCREEN:
               if ((((comp->lastHitX-COLUMN_WIDTH)/COLUMN_WIDTH) - comp->column) * dirToTarget > 0) {
                  // it hit in the same direction
                  vel -= ((float)(comp->lastMinDist)/900.0)/2.0; // 900 = 30^2 pixels away
               } else {
                 // Only way for this to happen is high winds!
                 angle += ftofix((7*((float)(comp->lastMinDist) / 900.0)) * dirToTarget);
               } // It hit behind shooter
          break;

          case BUILD_BLOW:
               fprintf(stderr, "A building blew up, damn it!\n");
/*               if ( ((float)comp->lastMinDist/900.0) < 2 ) {
                  fprintf(stderr, "last shot was within 60 pixels...\n");

                  if (abs(comp->lastMinX-ex) < abs(comp->lastMinY-ey))
                     vel -= (comp->lastMinX-ex)/6;
                  else
                     vel -= (comp->lastMinY-ey)/6;
               } else {
               } // Far away! */

               if (((comp->lastMinDist/900) < 2)) {
                  fprintf(stderr, "within 60 pixels!\n");
                  if ((comp->lastMinX/COLUMN_WIDTH) == (ex/COLUMN_WIDTH)) {
                  // Just missed over the column!
                     if (comp->lastMinY < ey)
                        upDown = 1;
                     else upDown = -1;
                  } else {
                    if ((comp->lastHitX-ex) * dirToTarget > 0) // Same direction!
                       upDown = 1;
                    else upDown = -1;
                  } // Not on same column!
               } else if (((comp->lastMinDist/900) > 32000)) {
                 // Prolly only happen on high winds, steep hangles
                 upDown = 0;
                 // You prolly shouldn't do the baseHeight check here, cause that
                 // guarantees it won't recover for being hit for a turn
                 if (guessBestAngle() < angle || (comp->baseHeight != sy)) {
                    firstShot();
                    vel = comp->velocity;
                    angle = comp->angle;
                 } else {
                   if (dirToTarget < 0) {
                      if (angle > itofix(LEFT_DIR+32))
                        angle += ftofix((7*((float)(comp->lastMinDist) / 900.0)) * dirToTarget);
                   } else if (fabs(fixtof(angle)) > 32)
                        angle += ftofix((7*((float)(comp->lastMinDist) / 900.0)) * dirToTarget);
                 } // Just shoot the wall down!
               } else {
                 upDown = -1;
               }

               vel -= (((float)(comp->lastMinDist)/900.0)/1.25) * upDown;
               if (vel > MAX_VELOCITY) {
                  angle += ftofix((16*((float)(vel) / MAX_VELOCITY)) * dirToTarget);
                  vel = MAX_VELOCITY;
               }
          break;
   } // end switch last hit type

   comp->velocity = vel;
   comp->angle = angle;

// end recalcShot
return 0;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
unsigned long guessTripTime(fixed angle) {
unsigned long res;

   // Change the value to return stuff depending on conditions...
   res = 75; // Moderate guess

   if (fabs((float)(UP_DIR)-fixtof(angle)) < 20)
      // For very steep shots, it takes more time!
      res += 20;

   if (fabs((float)(UP_DIR)-fixtof(angle)) > 44)
      // For very shallow shots, it takes less time!
      res -= 20;

   if (wind > (MAX_WIND/2)) { // It doesn't really matter otherwise!
      if (wind * dirToTarget > 0)   // They're both facing the same way!
         res -= 20; // It'll take a lot less time
      else res += 20;
   }

// end guessTripTime
return res;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
fixed guessBestAngle(void) {
int i, dy, dx;
fixed angle, ang;

   // attempts to guess the best angle, takng into account
   // angle it must be launched to not hit any buildings
   // and the angle it must land at to not hit buildings!

   angle = itofix(UP_DIR+(32*dirToTarget)); // Make it a 45% shot! Well, 32 in this system
//   angle = itofix((compSide==RIGHT)*LEFT_DIR);

   for (i=comp->column+dirToTarget; i != comp->column+(dirToTarget*numLookForward); i+=dirToTarget) {

      dy = (map[i].h-5)-(map[comp->column].h-5);
      dx = ((i-comp->column)*COLUMN_WIDTH)-((COLUMN_WIDTH/2)*dirToTarget);
         // That bit at the end about the half-width * dirToTarget places the angle calc
         // at the corner of the bulding, not the center
      ang = fatan2(itofix(dy), itofix(dx));
      if (ang < itofix(0))     // Conversion not needed, really...
         ang += itofix(DRIGHT_DIR);
      #ifdef DEBUG
             fprintf(stderr, "     build angle=%f\n", fixtof(ang));
      #endif

      if (fabs((float)(UP_DIR)-fixtof(ang)) < fabs((float)(UP_DIR)-fixtof(angle))) {
         angle = ang;
         #ifdef DEBUG
            fprintf(stderr, "tighter angle!\n");
         #endif
      } // ang is steeper than angle
   } // for i

   #ifdef DEBUG
          fprintf(stderr, "Guessed angle=%e\n", fixtof(angle));
   #endif

// end guessBestAngle
return angle;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
void getCompDir(void) {

   compSide = currPlayer;
   dirToTarget = (currPlayer==LEFT)?1:-1;

   #ifdef DEBUG
          fprintf(stderr, "Computer player is on the %s side and looks %i\n",
                 (compSide==LEFT)?"left":"right", dirToTarget);
   #endif

// end getCompDir
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
float guessBestVel(fixed angle, unsigned long tripTime) {
float vel, yvel, xvel, tTime;
int ex, ey, sy, sx;

   tTime = (float)(tripTime);

   sy = map[comp->column].h-5;
   sx = (comp->column*COLUMN_WIDTH) + 2 + ((COLUMN_WIDTH-4)/2);

   ey = map[comp->target->column].h-5;
   ex = (comp->target->column*COLUMN_WIDTH) + 2 + ((COLUMN_WIDTH-4)/2);

   yvel = -(((tTime*tTime)/10.0) + sy - ey) / tTime;
   xvel = -(((tTime*tTime) * (wind/(MAX_WIND*25.0))) + sx - ex) / tTime;

   xvel = (xvel/fixtof(fcos(angle)))*5;
   yvel = (yvel/fixtof(fsin(angle)))*5;
   #ifdef DEBUG
          fprintf(stderr, "   best xvel, yvel guess: %f, %f\n", xvel, yvel);
   #endif

   vel = (xvel + yvel)/2;  // Mush them together
   #ifdef DEBUG
          fprintf(stderr, "   best vel guess: %f\n", vel);
   #endif

// end guessBestVel
return vel;
}

