////////////////////////////////////////////////////////////
// game.h - BC game code header!
// Copyright Joe Kopena 1998
////////////////////////////////////////////////////////////

#ifndef GAME_HEADER
#define GAME_HEADER

#define NUM_BOMBERS     2
#define LEFT            0
#define RIGHT           1

#define NUM_COLUMNS     30
#define COLUMN_WIDTH    20
#define COLUMN_COLOR    (BRIGHT_GREEN)
#define MAX_HEIGHT      (SCREEN_H/3)
#define MIN_HEIGHT      (SCREEN_H-(MAX_HEIGHT/3))
#define DAMAGE          25
#define MIN_DAMAGE      12
#define ABS_MIN_HEIGHT  (SCREEN_H-10)

#define MAX_VELOCITY 100
#define MAX_VELBAR_H 100

#define PLAYER_QUIT  1
#define SHOT_KILLED  2

#define DEATH_DIST   225 // Remember, it's actually the distance squared! = 15

#define PLAY_ON         0
#define OFF_SCREEN      1
#define BUILD_BLOW      2
#define PLAYER_KILL     3

#define MAX_WIND        10.0

#define HUMAN     0
#define COMP      1

////////////////////////////////////////////////////////////
typedef struct playerBoxTyp playerBox, *playerBoxPtr;
struct playerBoxTyp {

   unsigned char color;
   char roundsWon :5;
   int score;
   fixed angle;
   float velocity;
   unsigned char column;
   unsigned char human :1;
   playerBoxPtr target;

   // The rest of this stuff is for the AI player(s)
   int lastHitType, lastHitX, lastHitY, lastMinDist, lastMinX, lastMinY, baseHeight;

}; // playerBoxTyp


typedef struct mapCellTyp mapCell, *mapCellPtr;
struct mapCellTyp {
       int h;
       unsigned char destroyed :1; // Only needs true/false
}; // mapCellTyp

////////////////////////////////////////////////////////////
void showVicScreen(void);

int setupGame(void);
void shutupGame(void);
void drawGame(void);
void drawGun(playerBoxPtr p);
void drawGuns(void);
void drawVelBar(void);
void drawWindBar(void);

int vertTextHeight(FONT *font, char *string);
void vertDrawText(BITMAP *bmp, FONT *font, char *string, int x, int y, int color);

void makeMap(void);
void drawMap(void);

void setupMatch(void);
void setupTurn(void);
int doHumanTurn(void);
int doCompTurn(void);

void drawShot(int x, int y, fixed angle, int color);
void drawGunBox(playerBoxPtr p);
int fireShot(void);
void drawLine(int ox, int oy, int x, int y);

void doPoints(void);

void drawExplosion(playerBoxPtr p, float x, float y);

void checkHit(BITMAP *bmp, int x, int y, int col);
int collisionCheck(playerBoxPtr p, float ox, float oy, float x, float y);
int getDistance(int col, int x, int y);

int takeScreenShot(void);

////////////////////////////////////////////////////////////
extern playerBox player[NUM_BOMBERS];
extern mapCell map[NUM_COLUMNS];
extern int currPlayer;
extern unsigned char gameDone, matchDone;
extern int minDistance;
extern int cx, cy, minX, minY;
extern char cRes;
extern char hitType;
extern float wind;
extern int numTurns;

#endif // GAME_HEADER

