////////////////////////////////////////////////////////////
// main.c - Main Bomber Command Code, variables
// Copyright Joe Kopena 1998
////////////////////////////////////////////////////////////

#include <stdio.h>
#include <math.h>
#include <time.h>
#include <strings.h>

#include <allegro.h>
#include <noflick.h>

#include "data.h" // Datafile header
#include "vars.h" // Global variables (which are defined here)

////////////////////////////////////////////////////////////
int setup(int argc, char *argv[]);
void shutdown(void);

int doMainMenu(void); // Defined in menu.c
int doGame(void);       // Defined in game.c

void makeExplosions(void);
void freeExplosions(void);

DATAFILE *data;
gameStats game;   // My game data struct
volatile unsigned long gameTime;
RLE_SPRITE *explosion[NUM_EXPLO_FRAMES];

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void incGameTime(void) {   // This has to be declared here so it can be
                           // locked later. I'm not sure if you can call
                           // LOCK_FUNCTION right after END_OF_FUNCTION

   gameTime++;

// end incGameTime
}
END_OF_FUNCTION(incGameTime);

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int main(int argc, char *argv[]) {
int err = 0;

   if (!(err = setup(argc, argv))) {

      while (!doMainMenu() && !err) { // Returns 1 on quit game!

         err = doGame();

      } // !doMainMenu

   } // !setup err

   shutdown();

   if (err) {
      printf("Error %i!\n", err);
   }

   #ifdef DEBUG
          fprintf(stderr, "\nDifficulty: %i\n", game.difficulty);
          fprintf(stderr, "Humans: %i\n", game.numPlayers);
          fprintf(stderr, "Rounds: %i\n", game.rounds);
          fprintf(stderr, "\ndrawMode: %i\n", game.drawMode);
   #endif // DEBUG

// end main
return err;
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int setup(int argc, char *argv[]) {
int err = 0;
char filename[80] = "";

   game.difficulty = EASY;
   game.numPlayers = 1;
   game.rounds = 3;
   game.drawMode = DRAW_NORMAL;

   srand((unsigned int)time(NULL));

   allegro_init(); // Has no errors possible

   install_timer();

   LOCK_VARIABLE(gameTime);   // System stuff
   LOCK_FUNCTION(incGameTime);
   install_int(incGameTime, 10);  // 100 incs per second

   install_keyboard();

   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0])) {
      fprintf(stderr, "No sound... \"%s\"\n", allegro_error);
      game.sound = 0;
   } else game.sound = 1;

   strcpy(game.mainPath, argv[0]);
   strcpy(get_filename(game.mainPath), "\0");
   #ifdef DEBUG
          fprintf(stderr, "game.mainPath= '%s'\n", game.mainPath);
   #endif

   strcpy(filename, argv[0]);
   strcpy(get_filename(filename), "\0");
   strcat(filename, "bomber.dat");

   if (!(data = load_datafile(filename))) {
      fprintf(stderr, "Could not load datafile %s!\n", filename);
      return -1;
   }

   if ((err=set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0))) {
      fprintf(stderr, "Could not set video mode! Allegro says %s!\n", allegro_error);
      return err;
   }

   set_palette(data[GAME_PAL].dat);

   text_mode(-1); // Don't draw font backgrounds!

   if ((err = ff_setup(SCREEN_W, SCREEN_H))) {
      fprintf(stderr, "Problem with flicker free setup!\n");
      return err;
   }

   makeExplosions();

// end setup
return err;
}

////////////////////////////////////////////////////////////
void shutdown(void) {

   freeExplosions();

   ff_shutdown();

   unload_datafile(data);

   clear_keybuf();   // Have to do this or it screws up sometimes and does not
                     // remove the keyboard handler!!!

   allegro_exit();   // reset the video mode and stuff like that so I can say stuff!!

// end shutdown
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void makeExplosions(void) {
BITMAP *bmp = create_bitmap(EXPLODE_SIZE, EXPLODE_SIZE);
unsigned char *p;
int c, c2;
int x, y;
int xx, yy;
int color;

   #define HOTSPOTS  64

   struct HOTSPOT {
      int x, y;
      int xc, yc;
   } hot[HOTSPOTS];

   for (c=0; c<HOTSPOTS; c++) {
      hot[c].x = hot[c].y = (EXPLODE_SIZE/2)<<16;
      hot[c].xc = (rand()&0xFFFF)-0x7FFF;
      hot[c].yc = (rand()&0xFFFF)-0x7FFF;
   }

   for (c=0; c<NUM_EXPLO_FRAMES; c++) {
      clear(bmp);

      color = ((c<16) ? c*4 : (80-c)) >> 2;

      for (c2=0; c2<HOTSPOTS; c2++) {
	       for (x=-6; x<=6; x++) {
	           for (y=-6; y<=6; y++) {
	               xx = (hot[c2].x>>16) + x;
	               yy = (hot[c2].y>>16) + y;
	               if ((xx>0) && (yy>0) && (xx<EXPLODE_SIZE) && (yy<EXPLODE_SIZE)) {
		               p = bmp->line[yy] + xx;
		               *p += (color >> ((ABS(x)+ABS(y))/3));
		               if (*p > 63)
		                  *p = 63;
                  }
              }
          }
	       hot[c2].x += hot[c2].xc;
	       hot[c2].y += hot[c2].yc;
      }

      for (x=0; x<EXPLODE_SIZE; x++) {
	       for (y=0; y<EXPLODE_SIZE; y++) {
	           c2 = bmp->line[y][x];
	           if (c2 < 8)
	              bmp->line[y][x] = 0;
              else
	               bmp->line[y][x] = 157+c2/4;
          }
      }

      explosion[c] = get_rle_sprite(bmp);
   }

   destroy_bitmap(bmp);
}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void freeExplosions(void) {
int i;

   for (i = 0; i < NUM_EXPLO_FRAMES; i++) {
       destroy_rle_sprite(explosion[i]);

   } // for i

// end freeExplosions
}

