////////////////////////////////////////////////////////////
// menu.c - Menu/Title Screen code for BC
// Copyright Joe Kopena 1998
////////////////////////////////////////////////////////////

#include <stdio.h>
#include <allegro.h>
#include <noflick.h>

#include "data.h"
#include "vars.h"
#include "colors.h"

#define NUM_CHOICES  7
#define HUMANS       0
#define DIFFICULTY   1
#define ROUNDS       2
#define DRAW         3
#define HELP         4
#define PLAY         5
#define QUIT         6

#define LEFT_ARROW    ">"
#define RIGHT_ARROW  "<"

#define COPY_NOTE  "Copyright Weasel Works 1998"

////////////////////////////////////////////////////////////
typedef struct menuTyp menuBox, *menuBoxPtr;
struct menuTyp {
       char line[32];
       int y;
       char font;
}; // menuTyp

menuBox menu[NUM_CHOICES] = {
        {"Humans", 200, LARGE_FONT},
        {"Diff", 225, LARGE_FONT},
        {"Rounds", 250, LARGE_FONT},
        {"Draw", 275, LARGE_FONT},
        {"Help", 325, LARGE_FONT},
        {"Play!", 400, LARGE_FONT},
        {"Quit", 425, LARGE_FONT}
   };

char choice = 0;
// char drawNum = 0;

////////////////////////////////////////////////////////////
void drawMenu(void);
void doHelp(void);

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
int doMainMenu(void) {
int k;
char done = 0;

   // Returns 1 on quit, 0 on play again!

   do {
      drawMenu();

      k = readkey() >> 8;

      switch (k) {
             case KEY_ESC:
                  // choice = QUIT;
                  // done = 1;
                  return 1; // quit doMenu with 1, thereby quitting the game
             break;
             case KEY_ENTER:
             case KEY_SPACE:
                  switch (choice) {
                         case HUMANS:
                              if ((game.numPlayers++) >= 2)
                                 game.numPlayers = 0;
                         break;

                         case DIFFICULTY:
                              if ((game.difficulty++) >= HARD)  // Three levels
                                 game.difficulty = 0;
                         break;

                         case ROUNDS:
                              if (game.rounds < 9)
                                 game.rounds += 2;
                              else if (game.rounds == 9)
                                   game.rounds = 21;
                              else game.rounds = 1;
                         break;

                         case DRAW:
                              game.drawMode++;
                              if (game.drawMode > DRAW_LINE) // 4
                                 game.drawMode = DRAW_NORMAL;
                         break;

                         case HELP:
                              doHelp();
                         break;

                         case PLAY:
                              return 0; // Quit menu, play the game!
                         break;

                         case QUIT:
                              // done = 1;
                              return 1; // quit game
                         break;
                  } // end switch choice
             break;

             case KEY_UP:
                  choice--;
                  if (choice < 0)
                     choice = NUM_CHOICES-1;
             break;
             case KEY_DOWN:
                  choice++;
                  if (choice >= NUM_CHOICES)
                     choice = 0;
             break;

      } // switch k

   } while (!done);

// end doMainMenu
return 0;
}

////////////////////////////////////////////////////////////
void drawMenu(void) {
int i;

   blit(bmp(TITLE_BMP), double_buffer, 0, 0, 0, 0, bmp(TITLE_BMP)->w, bmp(TITLE_BMP)->h);

   sprintf(menu[HUMANS].line, "%i Humans", game.numPlayers);
   if (game.numPlayers == 2) {
      strcpy(menu[DIFFICULTY].line, "The CompuBomber is not playing");
   } else
     switch (game.difficulty) {
          case EASY:
               strcpy(menu[DIFFICULTY].line, "The CompuBomber is stupid.");
          break;
          case MED:
               strcpy(menu[DIFFICULTY].line, "The CompuBomber is decent.");
          break;
          case HARD:
               strcpy(menu[DIFFICULTY].line, "The CompuBomber is deadly.");
          break;
     } // game.difficulty
   sprintf(menu[ROUNDS].line, "%i Rounds", game.rounds);

   switch (game.drawMode) {
          case DRAW_NORMAL:
               strcpy(menu[DRAW].line, "Normal Drawing");
          break;
          case DRAW_DOT:
               strcpy(menu[DRAW].line, "Dot-Trace Drawing");
          break;
          case DRAW_LINE:
               strcpy(menu[DRAW].line, "Line-Trace Drawing");
          break;
   } // switch drawNum

   for (i = 0; i < NUM_CHOICES; i++) {
       textout_centre(double_buffer, fnt(menu[i].font), menu[i].line, SCREEN_W/2, menu[i].y, -1);
   } // for i

   textout(double_buffer, fnt(LARGE_FONT), LEFT_ARROW,
      (SCREEN_W/2) - (text_length(fnt(LARGE_FONT), menu[choice].line)/2) - text_length(fnt(LARGE_FONT), LEFT_ARROW),
      menu[choice].y, -1);
   textout(double_buffer, fnt(LARGE_FONT), RIGHT_ARROW,
      (SCREEN_W/2) + (text_length(fnt(LARGE_FONT), menu[choice].line)/2)+2,
      menu[choice].y, -1);

   textout(double_buffer, font, COPY_NOTE, SCREEN_W-text_length(font, COPY_NOTE), 470, BLACK);

   ff_drawDB();

// end drawMenu
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
void doHelp(void) {

   clear_keybuf();

   blit(bmp(HELP_SCREEN0), screen, 0, 0, 0, 0, bmp(HELP_SCREEN0)->w, bmp(HELP_SCREEN0)->h);

   readkey();

// end doHelp
}

