////////////////////////////////////////////////////////////
// vars.h - Global variables for BC
// Copyright Joe Kopena 1998
////////////////////////////////////////////////////////////

#ifndef VARS_INC
#define VARS_INC

#define bmp(x)   ((BITMAP*)(data[x].dat))   // Casting macro
#define fnt(x)  ((FONT*)(data[x].dat))     // Casting macro

// #define DEBUG  // undefine if you don't want to debug stuff!

#define EASY   0  // Difficulty levels
#define MED    1
#define HARD   2

#define UP_DIR          192
#define DOWN_DIR        64
#define LEFT_DIR        128
#define RIGHT_DIR       0
#define DRIGHT_DIR      256

#define NUM_EXPLO_FRAMES   64
#define EXPLODE_SIZE       80

#define DRAW_NORMAL     0
#define DRAW_DOT        1
#define DRAW_LINE       2
// #define NO_REDRAW       8

typedef struct gameTyp gameStats, *gameStatsPtr;
struct gameTyp {

   unsigned char difficulty : 2; // Only three levels of difficulty!
   unsigned char numPlayers : 2; // 0, 1 or 2 human players
   unsigned char rounds : 5; // 1, 3, 5, 7, 9, or 21 rounds (can actually hold <= 32 (2^5))

   unsigned char sound:1;
   char mainPath[80];

   unsigned char drawMode : 2;

}; // gameTyp

extern DATAFILE *data;
extern gameStats game;
extern volatile unsigned long gameTime;
extern RLE_SPRITE *explosion[NUM_EXPLO_FRAMES];

#endif // VARS_INC

