#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

BOOL getLine(FILE *fp, char *line);

int PASCAL winMain(HANDLE hInst, HANDLE prev, LPSTR cmdLine, int show) {
FILE *fp;
char line[255];

	srand((unsigned int)time(NULL));
	
	fp = fopen("quotes.lst", "rt");
	if (!fp) {
		MessageBox(NULL, "Could not open quotes.lst!", "Error!", MB_OK | MB_ICONSTOP);
		return 1;
	}
	
	
	if (getLine(fp, line))
		return 1;
	
	MessageBox(NULL, line, "Quote of the Day!", MB_OK);
	
	fclose(fp);

// end winMain
return 0;
}

BOOL getLine(FILE *fp, char *line) {
int numQuotes, i;
char quotee[255];
char saying[255];

	if (!fgets(line, 255, fp)) {
		MessageBox(NULL, "IO Error reading number of quotes!", "Error!", MB_OK | MB_ICONSTOP);
		return 1;
	}
	
	numQuotes = atoi(line);
	
	i = (rand()%numQuotes)+1;

	while (i) {
		if (!fgets(saying, 255, fp)) {
			MessageBox(NULL, "IO Error reading quote!", "Error!", MB_OK | MB_ICONSTOP);
			return 1;
		}

		if (!fgets(quotee, 255, fp)) {
			MessageBox(NULL, "IO Error reading quotee!", "Error!", MB_OK | MB_ICONSTOP);
			return 1;
		}
		
		i--;
	}	
	
	
	
	strcpy(line, "");
	
	for (i = 0; i < (signed)(strlen(quotee)-strlen(saying))/2; i++)	// Center the shorter one!
		strcat(line, " ");
		
	strcat(line, saying);
	
	strcat(line, "\n");
	
	for (i = 0; i < (signed)(strlen(saying)-strlen(quotee))/2; i++)	// Center the shorter one!
		strcat(line, " ");
		
	strcat(line, quotee);
	
	for (i = 0; i < (signed)strlen(line); i++)
		if (line[i] == '#')
			line[i] = '\n';

// end getLine
return 0;
}
