' inpass.bas by Tek 
'
' I get questions on how to make a "password inputter" quite often. That is,
' people that want to know how to input a password like on the internet or
' somewhere you signin for something and the box shows *'s in place of text,
' in order to provide more security. Here is an example, commented, on how
' to do this.
'
' Any questions, comments, direct them to me.
'
' Tek
' neozones@quickbasic.com
' http://neozones.quickbasic.com/
'
'                                   *
' FUNCTION GetPassword$(Row, Col, MaxLength, HiddenChar$)
'       
'       - Row
'               This is the row where you want the password input to be. If
'               you specify -1, then it will automatically go to the current
'               row.
'       - Col
'               The column where you want password input to begin. If you
'               wanted the password or text to be entered in the top left
'               corner, you could use row 1 and col 1.
'       - MaxLength
'               You can limit the amount of letters entered to be as many or
'               as few as you want.
'       - HiddenChar$
'               You can tell the program what character you want to "hide"
'               the text. This character is classicly a * (asterisk), but a
'               space will work or whatever you want.
'
' EXAMPLES
'
'       - to get text at row 10, column 15, max length of 10, and place a *
'         over each letter:
'              
'               YourText$ = GetPassword$(10, 15, 10, "*")
'
'       - to get text at the current column and current row, max length of 5,
'         place a space over each letter:
'
'               YourText$ = GetPassword$(-1, -1, 5, " ")             

'
'

DEFINT A-Z
DECLARE FUNCTION GetPassword$ (row, Col, MaxLength, HiddenChar$)

CLS

PRINT "Enter your password: ";

Password$ = GetPassword$(-1, -1, 10, "*")

PRINT "Your password was: "; Password$

FUNCTION GetPassword$ (row, Col, MaxLength, HiddenChar$)

IF row = -1 THEN row = CSRLIN
IF Col = -1 THEN Col = POS(0)

IF LEN(HiddenChar$) <> 1 THEN HiddenChar$ = "*"

CurrentPassword$ = ""

LOCATE row, Col, 1

DO
 kbd$ = INKEY$
 IF kbd$ <> "" THEN
  SELECT CASE kbd$
   CASE CHR$(8)
    IF LEN(CurrentPassword$) > 0 THEN
     CurrentPassword$ = LEFT$(CurrentPassword$, LEN(CurrentPassword$) - 1)
     LOCATE row, Col + LEN(CurrentPassword$)
     PRINT " ";
     LOCATE row, Col + LEN(CurrentPassword$)
    END IF
   CASE ELSE
    IF LEN(CurrentPassword$) < MaxLength THEN
     IF LEN(kbd$) = 2 THEN kbd$ = RIGHT$(kbd$, 1)
     LOCATE row, Col + LEN(CurrentPassword$)
     CurrentPassword$ = CurrentPassword$ + kbd$
     PRINT HiddenChar$;
    END IF
  END SELECT
 END IF
LOOP UNTIL kbd$ = CHR$(13)

GetPassword$ = CurrentPassword$

LOCATE , , 0

PRINT

END FUNCTION

